<?php

namespace App\Entities\Users;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'email', 'password');
    protected $hidden = array('password');

    public function profile()
    {
        return $this->hasOne('Profile');
    }

    public function enrollments()
    {
        return $this->hasMany('Enrolment');
    }

    public function invoices()
    {
        return $this->hasMany('Invoice');
    }

    public function notifications()
    {
        return $this->hasMany('Notification');
    }

    public function bookings()
    {
        return $this->hasMany('Booking');
    }

}